/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.common.mobmetas;

import com.yollo.dmlreforged.common.items.ItemLivingMatter;
import com.yollo.dmlreforged.common.items.ItemPristineMatter;
import com.yollo.dmlreforged.core.configs.EnergyCostConfig;
import com.yollo.dmlreforged.core.configs.MobConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class MobMetaData {
    protected String name;
    private String pluralName;
    protected String key;
    protected int numberOfHearts;
    protected int interfaceScale;
    protected int interfaceOffsetX;
    protected int interfaceOffsetY;
    protected ItemLivingMatter livingMatter;
    protected ItemPristineMatter pristineMatter;
    protected String[] mobTrivia;

    public MobMetaData(String key, String name, String pluralName, int numberOfHearts, int interfaceScale, int interfaceOffsetX, int interfaceOffsetY, Item livingMatter, Item pristineMatter, String[] mobTrivia) {
        this.key = key;
        this.name = name;
        this.pluralName = pluralName;
        this.numberOfHearts = numberOfHearts;
        this.interfaceScale = interfaceScale;
        this.interfaceOffsetX = interfaceOffsetX;
        this.interfaceOffsetY = interfaceOffsetY;
        this.livingMatter = (ItemLivingMatter)livingMatter;
        this.pristineMatter = (ItemPristineMatter)pristineMatter;
        this.mobTrivia = mobTrivia;
    }

    public int getSimulationTickCost() {
        int cost = EnergyCostConfig.getCost(this.getKey());
        return cost;
    }

    public ItemStack getLivingMatterStack(int amount) {
        return new ItemStack((ItemLike)this.livingMatter, amount);
    }

    public ItemStack getPristineMatterStack(int amount) {
        return new ItemStack((ItemLike)this.pristineMatter, amount);
    }

    public String getName() {
        return this.name;
    }

    public String getPluralName() {
        return this.pluralName;
    }

    public String getKey() {
        return this.key;
    }

    public int getNumberOfHearts() {
        return this.numberOfHearts;
    }

    public int getInterfaceScale() {
        return this.interfaceScale;
    }

    public int getInterfaceOffsetX() {
        return this.interfaceOffsetX;
    }

    public int getInterfaceOffsetY() {
        return this.interfaceOffsetY;
    }

    public String getType() {
        return this.livingMatter.getType();
    }

    public ItemLivingMatter getLivingMatter() {
        return this.livingMatter;
    }

    public ItemPristineMatter getPristineMatter() {
        return this.pristineMatter;
    }

    public String[] getMobTrivia() {
        return this.mobTrivia;
    }

    public boolean entityLivingMatchesMob(LivingEntity entity) {
        ResourceLocation registryName = entity.m_6095_().getRegistryName();
        if (registryName != null) {
            String name = registryName.toString();
            for (String string : MobConfig.getMobs(this.getKey())) {
                if (!string.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract LivingEntity getEntity(Level var1);

    public Entity getExtraEntity(Level world) {
        return null;
    }

    public int getExtraInterfaceOffsetX() {
        return 0;
    }

    public int getExtraInterfaceOffsetY() {
        return 0;
    }

    public String getExtraTooltip() {
        return null;
    }
}

